#include "cgal_wrap.h"
#include <CGAL/Arr_linear_traits_2.h>
#include <CGAL/convex_hull_2.h>
#include <CGAL/Triangulation_2.h>
#include <list>
#include <CGAL/Exact_predicates_exact_constructions_kernel.h>

typedef CGAL::Exact_predicates_exact_constructions_kernel K;
typedef K::FT FT;
typedef K::Point_2 Point_2;
typedef K::Segment_2  Segment_2;

typedef CGAL::Triangulation_2<K> Triangulation2D;

typedef Triangulation2D::Vertex_circulator Vertex_circulator;
typedef Triangulation2D::Point             Point;

typedef Triangulation2D::Face_circulator  Face_circulator;
typedef Triangulation2D::Finite_faces_iterator  Finite_faces_iterator;

typedef std::list<Point_2> pointlist;

//alpha shape
#include <CGAL/Delaunay_triangulation_2.h>
#include <CGAL/Triangulation_hierarchy_2.h>
#include <CGAL/Alpha_shape_2.h>

typedef CGAL::Alpha_shape_vertex_base_2<K> Vb;
typedef CGAL::Alpha_shape_face_base_2<K>  Fb;
typedef CGAL::Triangulation_data_structure_2<Vb,Fb> Tds;
typedef CGAL::Delaunay_triangulation_2<K,Tds> DTriangulation_2;

typedef CGAL::Alpha_shape_2<DTriangulation_2>  Alpha_shape_2;
typedef Alpha_shape_2::Alpha_shape_edges_iterator Alpha_shape_edges_iterator;

typedef Alpha_shape_2::Face_iterator  Face_iterator;

double* gen2DAlphaShape(
        double* points,
        int num_points,        
        double alpha,
        bool regularized)
{
    double heightAt(0.);
    std::vector<double> cordList;
    std::vector<Point_2> input;
    for(int i(0);i<num_points;i++)
    {
        input.push_back(Point_2( points[i*3 + 0],points[i*3 + 1]));
        heightAt += points[i*3 + 2];
    }

    if(input.size())
        heightAt /= input.size();


    Alpha_shape_2 AS2(input.begin(), input.end(),FT(alpha));

    if(regularized)
        AS2.set_mode(Alpha_shape_2::REGULARIZED);



    for(Alpha_shape_edges_iterator it =  AS2.alpha_shape_edges_begin();
        it != AS2.alpha_shape_edges_end();
        ++it)
    {
        double x,y,z;

        x = CGAL::to_double((AS2.segment(*it)).vertex(0)[0]);
        y = CGAL::to_double((AS2.segment(*it)).vertex(0)[1]);
        cordList.push_back(x);
        cordList.push_back(y);
        cordList.push_back(heightAt);
        x = CGAL::to_double((AS2.segment(*it)).vertex(1)[0]);
        y = CGAL::to_double((AS2.segment(*it)).vertex(1)[1]);
        cordList.push_back(x);
        cordList.push_back(y);
        cordList.push_back(heightAt);
    }

    int listsize = 1 + cordList.size();

    static double* ddoublelist = new double[listsize];
    int i(0);
    //head
    ddoublelist[i++] = (double)(cordList.size());
    for(std::vector<double>::iterator itr = cordList.begin();
        itr != cordList.end();
        itr++)
    {
        ddoublelist[i++] = *itr;
    }

    return ddoublelist;
}
