#include "testdll.h"
#include <iostream>

#include "testdll.h"
#include <gmtl/gmtl.h>
#include <iostream>
#include <fstream>
#include "cgalFunction.h"

#include <CGAL/Exact_predicates_inexact_constructions_kernel.h>
#include <CGAL/Delaunay_triangulation_2.h>
//#include <iterator>

typedef CGAL::Exact_predicates_inexact_constructions_kernel K;
//typedef double NT;
//typedef CGAL::Simple_cartesian<NT> K;
typedef K::Point_2 Point_2;
typedef K::Iso_rectangle_2 Iso_rectangle_2;
typedef K::Segment_2 Segment_2;
typedef K::Ray_2 Ray_2;
typedef K::Line_2 Line_2;

#include <CGAL/Apollonius_graph_2.h>
#include <CGAL/Apollonius_graph_traits_2.h>

typedef CGAL::Apollonius_graph_traits_2<K>   Traits;
typedef CGAL::Apollonius_graph_2<Traits>     Apollonius_graph;

//A class to recover Voronoi diagram from stream.
class Cropped_voronoi_from_apollonius
{
public:
    std::list<Segment_2> m_cropped_vd;
    Iso_rectangle_2 m_bbox;

    Cropped_voronoi_from_apollonius(const Iso_rectangle_2& bbox):m_bbox(bbox){}

    template <class RSL>
    void crop_and_extract_segment(const RSL& rsl){
        CGAL::Object obj = CGAL::intersection(rsl,m_bbox);
        const Segment_2* s = CGAL::object_cast<Segment_2>(&obj);
        if(s)
        {
            m_cropped_vd.push_back(*s);
        }

    }

    void operator<<(const Ray_2& ray)    { crop_and_extract_segment(ray); }
    void operator<<(const Line_2& line)  { crop_and_extract_segment(line); }
    void operator<<(const Segment_2& seg){ crop_and_extract_segment(seg); }

    void reset() {
        m_cropped_vd.erase(m_cropped_vd.begin(), m_cropped_vd.end());
    }
};

void pushUnique(std::vector<gmtl::Point3d>& list, gmtl::Point3d pt)
{
    for(std::vector<gmtl::Point3d>::iterator itr = list.begin();
        itr != list.end();
        itr++)
    {
        if(pt == *itr)
            return;
    }

    list.push_back(pt);
}


DLLEXPORT double*
gen2DVoronoiDiagramC(
        int* totalsize,
        double* generatrix,
        int num_generatrix,
        double heightat,
        double recMinX,double recMinY,double recMaxX,double recMaxY)
{

    double pl_xmin(DBL_MAX);
    double pl_ymin(DBL_MAX);
    double pl_xmax(DBL_MIN);
    double pl_ymax(DBL_MIN);
    if((recMinX == 0. && recMinY == 0. && recMaxX == 0. && recMaxY == 0.) ||
            recMinX > recMaxX || recMinY > recMaxY)
    {
        for(int i(0);i<num_generatrix;i++)
        {
            if(generatrix[i*3 + 0] < pl_xmin)
                pl_xmin = generatrix[i*3 + 0];
            if(generatrix[i*3 + 1] < pl_ymin)
                pl_ymin = generatrix[i*3 + 1];

            if(generatrix[i*3 + 0] > pl_xmax)
                pl_xmax = generatrix[i*3 + 0];
            if(generatrix[i*3 + 1] > pl_ymax)
                pl_ymax = generatrix[i*3 + 1];
        }
    }else
    {
        pl_xmin = recMinX;
        pl_ymin = recMinY;
        pl_xmax = recMaxX;
        pl_ymax = recMaxY;
    }

    Apollonius_graph ag;
    for(int i(0);i<num_generatrix;i++)
    {
        Apollonius_graph::Point_2 pt(generatrix[i*3 + 0],generatrix[i*3 + 1]);
        Apollonius_graph::Site_2 site(pt,generatrix[i*3 + 2]);
        ag.insert(site);
    }

    Iso_rectangle_2 isorec(pl_xmin,pl_ymin,pl_xmax,pl_ymax);
    std::vector<std::vector<std::vector<gmtl::Point3d> > > cells;
    std::vector<int> linepts;
    std::vector<int> celllines;
    Apollonius_graph::Finite_vertices_iterator vit;
    for (vit = ag.finite_vertices_begin();
         vit != ag.finite_vertices_end();
         ++vit)
    {
        {

            std::vector<std::vector<gmtl::Point3d> > polylinelist;
            Apollonius_graph::Edge_circulator ec = ag.incident_edges(vit);
            Apollonius_graph::Edge_circulator done(ec);
            if (ec != 0)
            {
                do {
                    Cropped_voronoi_from_apollonius vor(isorec);
                    ag.draw_dual_edge(*ec, vor);

                    std::vector<gmtl::Point3d> points;
                    for(std::list<Segment_2>::iterator itr = vor.m_cropped_vd.begin();
                        itr != vor.m_cropped_vd.end();
                        ++itr)
                    {
                        gmtl::Point3d pts = gmtl::Point3d(itr->source()[0] ,heightat,itr->source()[1] );
                        gmtl::Point3d pte = gmtl::Point3d(itr->target()[0] ,heightat,itr->target()[1] );

                        pushUnique(points,pte);
                        pushUnique(points,pts);
                    }
                    if(points.size())
                    {
                        polylinelist.push_back(points);
                        linepts.push_back(points.size());
                    }
                    vor.reset();
                } while(++ec != done);
            }
            cells.push_back(polylinelist);
            celllines.push_back(polylinelist.size());
        }
    }

    int totald(0);
    for(std::vector<std::vector<std::vector<gmtl::Point3d> > >::iterator itr = cells.begin();
        itr != cells.end();
        itr++)
    {
        for(std::vector<std::vector<gmtl::Point3d> >::iterator clitr = itr->begin();
            clitr != itr->end();
            clitr++)
        {
            for(std::vector<gmtl::Point3d>::iterator iitr = clitr->begin();
                iitr != clitr->end();
                iitr++)
            {
                totald++;
            }
        }
    }

    int num_cell = cells.size();
    int listsize = 1 + celllines.size() + linepts.size() + totald * 3;
    *totalsize = listsize;



    static double* ddoublelist = new double[listsize];
    int i(0);

    //head
    ddoublelist[i++] = num_cell;

    //cell edges num
    for(std::vector<int>::iterator itr = celllines.begin();
        itr != celllines.end();
        itr++)
    {
        ddoublelist[i++] = *itr;
    }

    //edge points num
    for(std::vector<int>::iterator itr = linepts.begin();
        itr != linepts.end();
        itr++)
    {
        ddoublelist[i++] = *itr;
    }

    //coordinates
    for(std::vector<std::vector<std::vector<gmtl::Point3d> > >::iterator itr = cells.begin();
        itr != cells.end();
        itr++)
    {
        for(std::vector<std::vector<gmtl::Point3d> >::iterator clitr = itr->begin();
            clitr != itr->end();
            clitr++)
        {
            for(std::vector<gmtl::Point3d>::iterator iitr = clitr->begin();
                iitr != clitr->end();
                iitr++)
            {
                ddoublelist[i++] = (*iitr)[0];
                ddoublelist[i++] = (*iitr)[1];
                ddoublelist[i++] = (*iitr)[2];
            }
        }
    }

    return ddoublelist;
}



DLLEXPORT int addadd(int a)
{
    return a* 10 + 2;
}

DLLEXPORT double addaddd(double a, double* res)
{
    *res = a*a / 100.;
    return a*a / 100.;
}

DLLEXPORT int addref(int a, int* res)
{
    *res = a*a;
    return a + 5;
}

DLLEXPORT float addaddf(float a)
{
    return a*a / 100.;
}

DLLEXPORT int ppow(int a)
{
    return a*a;
}


DLLEXPORT float addf(float a, float b)
{
    return a+b;
}

DLLEXPORT double* test3(int size, int a)
{
    double* ar = new double[5];
    ar[0] = 0.1;
    ar[1] = 0.2;
    ar[2] = 0.3;
    ar[3] = 0.4;
    ar[4] = (double)a;
    return ar;
}

DLLEXPORT void voronoi_w(double* ptr, int size, double* ptr_res)
{
    double* r = new double[size];
    //double r[5];
    for (int i(0); i < size; i++)
    {
        r[i] = 0.3;
    }

    ptr_res = r;
}

DLLEXPORT void delarray(double* ptr)
{
    delete[] ptr;
}


DLLEXPORT double sum_list(double* ptr, const int size, double* res)
{
    double sum(0.);
    for (int i(0); i < size; i++)
    {
        //std::cout << ptr[i] << std::endl;
        sum += ptr[i];//ptr[i]*3.;
    }
    *res = sum;
    return sum;
}
